/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.caffeinemc.mods.sodium.client.gl.attribute.GlVertexFormat;
import net.caffeinemc.mods.sodium.client.gl.device.CommandList;
import net.caffeinemc.mods.sodium.client.gl.device.RenderDevice;
import net.caffeinemc.mods.sodium.client.gl.shader.GlProgram;
import net.caffeinemc.mods.sodium.client.gl.shader.GlShader;
import net.caffeinemc.mods.sodium.client.gl.shader.ShaderConstants;
import net.caffeinemc.mods.sodium.client.gl.shader.ShaderLoader;
import net.caffeinemc.mods.sodium.client.gl.shader.ShaderType;
import net.caffeinemc.mods.sodium.client.render.chunk.ChunkRenderer;
import net.caffeinemc.mods.sodium.client.render.chunk.shader.ChunkFogMode;
import net.caffeinemc.mods.sodium.client.render.chunk.shader.ChunkShaderInterface;
import net.caffeinemc.mods.sodium.client.render.chunk.shader.ChunkShaderOptions;
import net.caffeinemc.mods.sodium.client.render.chunk.shader.DefaultShaderInterface;
import net.caffeinemc.mods.sodium.client.render.chunk.shader.ShaderBindingContext;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.format.ChunkVertexType;
import net.caffeinemc.mods.sodium.client.util.FogParameters;
import net.caffeinemc.mods.sodium.mixin.core.GlCommandEncoderAccessor;
import net.minecraft.class_10865;
import net.minecraft.class_10868;
import net.minecraft.class_12137;
import net.minecraft.class_276;
import net.minecraft.class_2960;

public abstract class ShaderChunkRenderer
implements ChunkRenderer {
    private final Map<ChunkShaderOptions, GlProgram<ChunkShaderInterface>> programs = new Object2ObjectOpenHashMap();
    protected final ChunkVertexType vertexType;
    protected final GlVertexFormat vertexFormat;
    protected final RenderDevice device;
    protected GlProgram<ChunkShaderInterface> activeProgram;

    public ShaderChunkRenderer(RenderDevice device, ChunkVertexType vertexType) {
        this.device = device;
        this.vertexType = vertexType;
        this.vertexFormat = vertexType.getVertexFormat();
    }

    protected GlProgram<ChunkShaderInterface> compileProgram(ChunkShaderOptions options) {
        GlProgram<ChunkShaderInterface> program = this.programs.get(options);
        if (program == null) {
            program = this.createShader("blocks/block_layer_opaque", options);
            this.programs.put(options, program);
        }
        return program;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GlProgram<ChunkShaderInterface> createShader(String path, ChunkShaderOptions options) {
        ShaderConstants constants = ShaderChunkRenderer.createShaderConstants(options);
        GlShader vertShader = ShaderLoader.loadShader(ShaderType.VERTEX, class_2960.method_60655((String)"sodium", (String)(path + ".vsh")), constants);
        GlShader fragShader = ShaderLoader.loadShader(ShaderType.FRAGMENT, class_2960.method_60655((String)"sodium", (String)(path + ".fsh")), constants);
        try {
            GlProgram<ChunkShaderInterface> glProgram = GlProgram.builder(class_2960.method_60655((String)"sodium", (String)"chunk_shader")).attachShader(vertShader).attachShader(fragShader).bindAttribute("a_Position", 0).bindAttribute("a_Color", 1).bindAttribute("a_TexCoord", 2).bindAttribute("a_LightAndData", 3).bindFragmentData("fragColor", 0).link(shader -> new DefaultShaderInterface((ShaderBindingContext)shader, options));
            return glProgram;
        }
        finally {
            vertShader.delete();
            fragShader.delete();
        }
    }

    private static ShaderConstants createShaderConstants(ChunkShaderOptions options) {
        ShaderConstants.Builder builder = ShaderConstants.builder();
        builder.addAll(options.fog().getDefines());
        if (options.pass().supportsFragmentDiscard()) {
            builder.add("USE_FRAGMENT_DISCARD");
        }
        builder.add("USE_VERTEX_COMPRESSION");
        return builder.build();
    }

    protected void begin(TerrainRenderPass pass, FogParameters parameters, class_12137 terrainSampler) {
        class_276 target = pass.getTarget();
        GlStateManager._viewport((int)0, (int)0, (int)target.method_30277().getWidth(0), (int)target.method_30277().getHeight(0));
        GlStateManager._glBindFramebuffer((int)36160, (int)((class_10868)target.method_30277()).method_68426(((class_10865)RenderSystem.getDevice()).method_68401(), target.method_30278()));
        ((GlCommandEncoderAccessor)RenderSystem.getDevice().createCommandEncoder()).sodium$applyPipelineState(pass.getPipeline());
        ((GlCommandEncoderAccessor)RenderSystem.getDevice().createCommandEncoder()).sodium$setLastProgram(null);
        ChunkShaderOptions options = new ChunkShaderOptions(ChunkFogMode.SMOOTH, pass, this.vertexType);
        this.activeProgram = this.compileProgram(options);
        this.activeProgram.bind();
        this.activeProgram.getInterface().setupState(pass, parameters, terrainSampler);
    }

    protected void end(TerrainRenderPass pass) {
        this.activeProgram.getInterface().resetState();
        this.activeProgram.unbind();
        this.activeProgram = null;
    }

    @Override
    public void delete(CommandList commandList) {
        this.programs.values().forEach(GlProgram::delete);
    }
}

